<?php

namespace App\Imports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Maatwebsite\Excel\Concerns\WithUpserts;

class UsersImport implements ToModel, WithHeadingRow, WithUpserts
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */

    public function uniqueBy()
    {
        return 'Patient_Identification_Number';
    }
    public function model(array $row)
    {

        // $splitName = explode(' ', $row['patient'], 2); // Restricts it to only 2 values, for names like Billy Bob Jones

        // $first_name = $splitName[0];

        // $last_name = !empty($splitName[1]) ? $splitName[1] : ''; // If last name doesn't exist, make it empty

        $name = $row['first_name'] . ' ' . $row['last_name'];
        if ($row['dob'] == '') {
            $dob = NULL;
        } else {
            $dob = date("Y-m-d", strtotime($row['dob']));
        }

        $slug = SlugService::createSlug(
            User::class,
            'slug',
            $name
        );

        $r = [
            'VP_ID' => $row['vp_id'],
            'VP_NAME' => $row['vp_name'],
            'UserId' => $row['userid'],
            'Patient_Identification_Number' => $row['patient_identification_number'],
            'First_Name' => $row['first_name'],
            'Last_Name' => $row['last_name'],
            'slug' => $slug,
            'Email' => $row['email'],
            'Phone_Code' => $row['phone_code'],
            'phone' => $row['phone'],
            'sms' => $row['sms'],
            'Gender' => $row['gender'],
            'Weight' => $row['weight'],
            'Height' => $row['height'],
            'DOB' =>  $dob,
            'Blood_Type' => $row['blood_type'],
            'Patient_Status' => $row['patient_status'],
            'Reg_Date' => date("Y-m-d", strtotime($row['reg_date'])),
            // 'location' => $row['location'],
            // 'context' => $row['context']
        ];
        return new User($r);
        // $data = User::where('Patient_Identification_Number', $row['patient_identification_number'])->first();

        // if ($data == null) {
        //     $user = new User($r);
        // } else {
        //     $user = User::where('id', $data->id)->update($r);
        // }
        // return $user;
    }
}
